<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../models/Venta.php';

$model = new Venta($pdo);
$ventas = $model->allWithRelations();
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Ventas</h1>
        <div class="card">
            <div class="card-body p-0">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Fecha</th>
                            <th>Mesa</th>
                            <th>Usuario</th>
                            <th>Método</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($ventas as $v): ?>
                        <tr>
                            <td><?php echo $v['id']; ?></td>
                            <td><?php echo $v['fecha']; ?></td>
                            <td><?php echo $v['mesa']; ?></td>
                            <td><?php echo htmlspecialchars($v['usuario']); ?></td>
                            <td><?php echo $v['metodo'] ?: '-'; ?></td>
                            <td><?php echo $v['total']; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
