<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Usuario.php';
$model = new Usuario($pdo);
$usuarios = $model->all();
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Usuarios</h1>
        <a href="index.php?page=usuarios/create" class="btn btn-primary mb-3">Nuevo Usuario</a>
        <div class="card">
            <div class="card-body p-0">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Usuario</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($usuarios as $u): ?>
                        <tr>
                            <td><?php echo $u['id']; ?></td>
                            <td><?php echo htmlspecialchars($u['nombre']); ?></td>
                            <td><?php echo $u['usuario']; ?></td>
                            <td>
                                <a href="index.php?page=usuarios/view&id=<?php echo $u['id']; ?>" class="btn btn-sm btn-secondary">Ver</a>
                                <a href="index.php?page=usuarios/edit&id=<?php echo $u['id']; ?>" class="btn btn-sm btn-info">Editar</a>
                                <a href="controllers/usuarios.php?delete=<?php echo $u['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar?')">Eliminar</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
