<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Producto.php';
$model = new Producto($pdo);
$productos = $model->all();
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Productos</h1>
        <a href="index.php?page=productos/create" class="btn btn-primary mb-3">Nuevo Producto</a>
        <div class="card">
            <div class="card-body p-0">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Nombre</th>
                            <th>Categor&iacute;a</th>
                            <th>Precio</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($productos as $p): ?>
                        <tr>
                            <td><?php echo $p['id']; ?></td>
                            <td><?php echo htmlspecialchars($p['nombre']); ?></td>
                            <td><?php echo $p['categoria']; ?></td>
                            <td><?php echo $p['precio']; ?></td>
                            <td>
                                <a href="index.php?page=productos/view&id=<?php echo $p['id']; ?>" class="btn btn-sm btn-secondary">Ver</a>
                                <a href="index.php?page=productos/edit&id=<?php echo $p['id']; ?>" class="btn btn-sm btn-info">Editar</a>
                                <a href="controllers/productos.php?delete=<?php echo $p['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar?')">Eliminar</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
