<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Categoria.php';
$catModel = new Categoria($pdo);
$categorias = $catModel->all();
$dir = __DIR__ . '/../../uploads/productos';
$existingImages = is_dir($dir) ? array_values(array_diff(scandir($dir), ['.', '..'])) : [];
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Nuevo Producto</h1>
        <div class="card">
            <div class="card-body">
                <form method="POST" action="controllers/productos.php" enctype="multipart/form-data">
                    <div class="form-group">
                        <label>Nombre</label>
                        <input type="text" name="nombre" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Descripci&oacute;n</label>
                        <input type="text" name="descripcion" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Categor&iacute;a</label>
                        <select name="categoria_id" class="form-control">
                            <option value="">-- Seleccione --</option>
                            <?php foreach ($categorias as $c): ?>
                            <option value="<?php echo $c['id']; ?>">
                                <?php echo htmlspecialchars($c['nombre']); ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Precio</label>
                        <input type="number" step="0.01" name="precio" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Imagen (opcional)</label>
                        <input type="file" name="imagen" class="form-control-file">
                    </div>
                    <?php if ($existingImages): ?>
                    <div class="form-group">
                        <label>O seleccionar existente</label>
                        <select name="imagen_existente" class="form-control">
                            <option value="">-- Ninguna --</option>
                            <?php foreach ($existingImages as $img): ?>
                            <option value="<?php echo 'uploads/productos/' . $img; ?>"><?php echo $img; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php endif; ?>
                    <button class="btn btn-primary" type="submit">Guardar</button>
                    <a href="index.php?page=productos" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </div>
    </div>
</section>
