<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Mesa.php';
require_once __DIR__ . '/../../models/Orden.php';

$mesaModel = new Mesa($pdo);
$ordenModel = new Orden($pdo);
$mesas = $mesaModel->all();
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Mesas</h1>
        <div class="row">
            <?php foreach ($mesas as $m): ?>
            <?php $orden = $ordenModel->findActiveByMesa($m['id']); ?>
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="card-title">Mesa <?php echo $m['numero']; ?></h5>
                        <p class="card-text">Estado: <?php echo $m['estado']; ?></p>
                        <?php if ($m['estado'] === 'disponible'): ?>
                            <a class="btn btn-primary" href="controllers/orden.php?action=new&mesa_id=<?php echo $m['id']; ?>">Nueva Orden</a>
                        <?php elseif ($orden): ?>
                            <a class="btn btn-info" href="index.php?page=orden/edit&id=<?php echo $orden['id']; ?>">Ver Orden</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
