<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Mesa.php';
$model = new Mesa($pdo);
$mesas = $model->all();
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Mesas</h1>
        <a href="index.php?page=mesas/create" class="btn btn-primary mb-3">Nueva Mesa</a>
        <div class="card">
            <div class="card-body p-0">
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>N&uacute;mero</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($mesas as $m): ?>
                        <tr>
                            <td><?php echo $m['id']; ?></td>
                            <td><?php echo $m['numero']; ?></td>
                            <td><?php echo $m['estado']; ?></td>
                            <td>
                                <a href="index.php?page=mesas/view&id=<?php echo $m['id']; ?>" class="btn btn-sm btn-secondary">Ver</a>
                                <a href="index.php?page=mesas/edit&id=<?php echo $m['id']; ?>" class="btn btn-sm btn-info">Editar</a>
                                <a href="controllers/mesas.php?delete=<?php echo $m['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar?')">Eliminar</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
