<?php
require_once 'Model.php';
class Venta extends Model {
    public function __construct(PDO $pdo) {
        parent::__construct($pdo, 'ventas', ['usuario_id','mesa_id','fecha','total','metodo_pago_id']);
    }

    public function allWithRelations(): array {
        $sql = "SELECT v.*, u.nombre AS usuario, m.numero AS mesa, mp.metodo
                FROM ventas v
                LEFT JOIN usuarios u ON v.usuario_id = u.id
                LEFT JOIN mesas m ON v.mesa_id = m.id
                LEFT JOIN metodos_pago mp ON v.metodo_pago_id = mp.id
                ORDER BY v.fecha DESC";
        return $this->pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
