<?php
require_once 'Model.php';
class Producto extends Model {
    public function __construct(PDO $pdo) {
        parent::__construct($pdo, 'productos', ['nombre', 'descripcion', 'precio', 'categoria_id', 'imagen']);
    }

    public function all(): array {
        $sql = "SELECT p.*, c.nombre AS categoria FROM productos p LEFT JOIN categorias c ON p.categoria_id = c.id";
        return $this->pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }

    public function find(int $id): ?array {
        $stmt = $this->pdo->prepare("SELECT p.*, c.nombre AS categoria FROM productos p LEFT JOIN categorias c ON p.categoria_id = c.id WHERE p.id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
    }

    public function byCategoria(int $categoriaId): array {
        $stmt = $this->pdo->prepare(
            "SELECT p.*, c.nombre AS categoria FROM productos p LEFT JOIN categorias c ON p.categoria_id = c.id WHERE p.categoria_id = ?"
        );
        $stmt->execute([$categoriaId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
