<?php
require_once 'Model.php';
class Orden extends Model {
    public function __construct(PDO $pdo) {
        parent::__construct($pdo, 'ordenes', ['mesa_id', 'usuario_id', 'estado']);
    }

    public function findActiveByMesa(int $mesaId): ?array {
        $stmt = $this->pdo->prepare("SELECT * FROM ordenes WHERE mesa_id = ? AND estado IN ('pendiente','pendiente en cocina','en preparacion','terminado') ORDER BY id DESC LIMIT 1");
        $stmt->execute([$mesaId]);
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
    }

    public function getEnPreparacion(): array {
        $sql = "SELECT o.*, m.numero AS mesa FROM ordenes o JOIN mesas m ON o.mesa_id=m.id WHERE o.estado IN ('pendiente en cocina','en preparacion','terminado')";
        return $this->pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
