<?php
require_once 'Model.php';
class Caja extends Model {
    public function __construct(PDO $pdo) {
        parent::__construct($pdo, 'cajas', ['usuario_id','fecha_apertura','fecha_cierre','monto_inicial']);
    }

    public function getAbierta(): ?array {
        $stmt = $this->pdo->query("SELECT * FROM cajas WHERE fecha_cierre IS NULL ORDER BY id DESC LIMIT 1");
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
        parent::__construct($pdo, 'cajas', ['usuario_id','fecha_apertura','fecha_cierre','monto_inicial','saldo_final']);
    }

    public function getOpen(): ?array {
        $stmt = $this->pdo->prepare("SELECT * FROM cajas WHERE fecha_cierre IS NULL ORDER BY id DESC LIMIT 1");
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;

        parent::__construct($pdo, 'cajas', ['usuario_id','fecha_apertura','monto_inicial','fecha_cierre','monto_cierre','estado']);
    }

    public function open(array $data): void {
        $this->create($data);
    }

    public function close(int $id, array $data): void {
        $this->update($id, $data);
    }
}
?>
