<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
// Simple POS Restaurant index using AdminLTE 3 and partials
include __DIR__ . '/includes/header.php';
include __DIR__ . '/includes/sidebar.php';

$page = $_GET['page'] ?? 'dashboard';
$path = __DIR__ . '/views/' . $page;
$view = '';
if (is_file($path . '.php')) {
    $view = $path . '.php';
} elseif (is_file($path . '/index.php')) {
    $view = $path . '/index.php';
}
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <?php
    if ($view && file_exists($view)) {
        include $view;
    } else {
        include __DIR__ . '/views/dashboard.php';
    }
    ?>
</div>
<!-- /.content-wrapper -->
<?php include __DIR__ . '/includes/footer.php';
?>

