-- phpMyAdmin SQL Dump
-- version 5.2.0
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1
-- Tiempo de generación: 04-07-2025 a las 03:30:56
-- Versión del servidor: 10.4.27-MariaDB
-- Versión de PHP: 7.4.33

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `pos_db`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cajas`
--

CREATE TABLE `cajas` (
  `id` int(11) NOT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha_apertura` datetime DEFAULT current_timestamp(),
  `fecha_cierre` datetime DEFAULT NULL,
  `monto_inicial` decimal(10,2) DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `caja_movimientos`
--

CREATE TABLE `caja_movimientos` (
  `id` int(11) NOT NULL,
  `caja_id` int(11) DEFAULT NULL,
  `venta_id` int(11) DEFAULT NULL,
  `metodo_pago_id` int(11) DEFAULT NULL,
  `tipo` enum('ingreso','egreso') NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `fecha` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `categorias`
--

CREATE TABLE `categorias` (
  `id` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `descripcion` text DEFAULT NULL,
  `icono` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `categorias`
--

INSERT INTO `categorias` (`id`, `nombre`, `descripcion`, `icono`) VALUES
(1, 'Bebidas', 'Bebidas frías y calientes', '🍹'),
(2, 'Comida rápida', 'Platos listos para servir', '🍱'),
(3, 'Postres', 'Dulces y postres', '🍰'),
(4, 'Entradas / Aperitivos', 'Nachos, alitas, sopas, ensaladas pequeñas', '🥘 '),
(5, 'Platos fuertes', 'Carnes, pescados, pastas, hamburguesas, tacos, etc.', '🍝 '),
(6, 'Snacks / Bocadillos', 'Sandwiches, burritos, empanadas, hot dogs', '🥪'),
(7, 'Pizzas / Panadería', 'Pizzas, baguettes, pan con ajo', '🍕'),
(8, 'Ensaladas', '', '🥗'),
(9, 'Especialidades', 'Comida regional, gourmet, o del chef', '🍣 '),
(10, 'Acompañamientos / Guarniciones', 'Papas, arroz, vegetales, tortillas', '🍟 '),
(11, 'Bebidas alcohólicas', 'Cerveza, vino, cocteles, licores', '🍻 '),
(12, 'Bebidas caliente', 'Café, té, chocolate caliente', '☕'),
(13, 'Desayunos', 'Hot Cakes, Hot Dogs, Wafles, Chilaquiles', '🥞');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_orden`
--

CREATE TABLE `detalle_orden` (
  `id` int(11) NOT NULL,
  `orden_id` int(11) DEFAULT NULL,
  `producto_id` int(11) DEFAULT NULL,
  `cantidad` int(11) NOT NULL,
  `precio_unitario` decimal(10,2) NOT NULL,
  `estado` enum('pendiente','en preparacion','terminado','servido') DEFAULT 'pendiente'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_venta`
--

CREATE TABLE `detalle_venta` (
  `id` int(11) NOT NULL,
  `venta_id` int(11) DEFAULT NULL,
  `producto_id` int(11) DEFAULT NULL,
  `cantidad` int(11) NOT NULL,
  `precio_unitario` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `entradas_insumo`
--

CREATE TABLE `entradas_insumo` (
  `id` int(11) NOT NULL,
  `insumo_id` int(11) DEFAULT NULL,
  `cantidad` decimal(10,2) NOT NULL,
  `precio_compra` decimal(10,2) NOT NULL,
  `fecha` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `entradas_insumo`
--

INSERT INTO `entradas_insumo` (`id`, `insumo_id`, `cantidad`, `precio_compra`, `fecha`) VALUES
(1, 1, '10.00', '80.00', '2025-07-02 20:48:21'),
(2, 2, '50.00', '20.00', '2025-07-02 20:48:21'),
(3, 3, '5.00', '32.50', '2025-07-02 20:48:21'),
(4, 4, '10.00', '12.00', '2025-07-02 20:48:21'),
(5, 5, '15.00', '15.00', '2025-07-02 20:48:21');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `insumos`
--

CREATE TABLE `insumos` (
  `id` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `unidad_medida` varchar(20) NOT NULL,
  `precio_unitario` decimal(10,2) NOT NULL,
  `stock` decimal(10,2) DEFAULT 0.00,
  `activo` tinyint(4) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `insumos`
--

INSERT INTO `insumos` (`id`, `nombre`, `unidad_medida`, `precio_unitario`, `stock`, `activo`) VALUES
(1, 'Leche', 'lt', '0.80', '20.00', 1),
(2, 'Agua', 'lt', '0.50', '50.00', 1),
(3, 'Tomate', 'kg', '1.00', '30.00', 1),
(4, 'Lechuga', 'pieza', '0.70', '25.00', 1),
(5, 'Queso', 'kg', '4.00', '15.00', 1),
(6, 'Aceite', 'lt', '1.20', '10.00', 1),
(7, 'Pollo', 'kg', '3.50', '20.00', 1),
(8, 'Pasta', 'kg', '1.50', '30.00', 1),
(9, 'Pescado', 'kg', '5.00', '10.00', 1),
(10, 'Tortilla', 'pieza', '0.10', '100.00', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `mesas`
--

CREATE TABLE `mesas` (
  `id` int(11) NOT NULL,
  `numero` int(11) NOT NULL,
  `estado` enum('disponible','ocupada','reservada') DEFAULT 'disponible'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `mesas`
--

INSERT INTO `mesas` (`id`, `numero`, `estado`) VALUES
(1, 1, 'disponible'),
(2, 2, 'disponible'),
(3, 3, 'disponible'),
(4, 4, 'disponible');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `metodos_pago`
--

CREATE TABLE `metodos_pago` (
  `id` int(11) NOT NULL,
  `metodo` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `metodos_pago`
--

INSERT INTO `metodos_pago` (`id`, `metodo`) VALUES
(1, 'Efectivo'),
(2, 'Tarjeta'),
(3, 'Transferencia');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `movimientos_caja`
--

CREATE TABLE `movimientos_caja` (
  `id` int(11) NOT NULL,
  `caja_id` int(11) DEFAULT NULL,
  `fecha` datetime DEFAULT current_timestamp(),
  `tipo` enum('ingreso','egreso') NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ordenes`
--

CREATE TABLE `ordenes` (
  `id` int(11) NOT NULL,
  `mesa_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha` datetime DEFAULT current_timestamp(),
  `estado` enum('pendiente en cocina','en preparacion','finalizado','pendiente') DEFAULT 'pendiente'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `ordenes`
--

INSERT INTO `ordenes` (`id`, `mesa_id`, `usuario_id`, `fecha`, `estado`) VALUES
(1, 1, 1, '2025-07-03 13:13:36', 'finalizado'),
(2, 2, 1, '2025-07-03 13:24:24', 'finalizado'),
(3, 4, 1, '2025-07-03 13:46:33', 'finalizado'),
(4, 1, 1, '2025-07-03 15:17:37', 'finalizado');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `productos`
--

CREATE TABLE `productos` (
  `id` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `descripcion` text DEFAULT NULL,
  `precio` decimal(10,2) NOT NULL,
  `categoria_id` int(11) DEFAULT NULL,
  `stock` int(11) DEFAULT 0,
  `imagen` varchar(255) DEFAULT NULL,
  `activo` tinyint(4) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `productos`
--

INSERT INTO `productos` (`id`, `nombre`, `descripcion`, `precio`, `categoria_id`, `stock`, `imagen`, `activo`) VALUES
(1, 'Café americano', 'Taza de café caliente', '22.20', 1, 100, 'uploads/productos/6866011254b91-cafe-americano.png', 1),
(2, 'Hamburguesa sencilla', 'Clásica hamburguesa', '83.25', 2, 50, 'uploads/productos/6867186279931-hamburguesa.png', 1),
(3, 'Porción de pastel', 'Pastel de chocolate', '37.00', 3, 40, 'uploads/productos/686719038e14e-porcion-de-pastel.png', 1),
(4, 'Alitas Adobadas', 'Alitas Adobadas', '64.75', 2, 0, 'uploads/productos/6866c36087445-alitas-adobadas.png', 1),
(5, 'HotCakes', 'HotCakes', '74.00', 13, 0, 'uploads/productos/6866d967236e0-hotcakes.png', 1),
(6, 'Latte', 'Café con leche espumosa', '46.25', 12, 60, 'uploads/productos/686719dc9aecd-latte.png', 1),
(7, 'Espresso', 'Shot de café concentrado', '33.30', 12, 80, 'uploads/productos/68671a3e7c85c-espresso.png', 1),
(8, 'Té helado', 'Té negro con hielo', '22.20', 1, 40, 'uploads/productos/68671a718f1ed-te-helado.png', 1),
(9, 'Limonada', 'Bebida de limón natural', '18.50', 1, 50, 'uploads/productos/68671ab976f7e-limonada.png', 1),
(10, 'Hamburguesa con queso', 'Hamburguesa clásica con queso', '101.75', 2, 30, 'uploads/productos/68671b312cc28-hamburguesa-con-queso.png', 1),
(11, 'Papas fritas', 'Papas sazonadas y crujientes', '37.00', 10, 100, 'uploads/productos/68671b7dba900-papas-fritas.png', 1),
(12, 'Brownie', 'Brownie de chocolate', '40.70', 3, 45, 'uploads/productos/68671bae214b0-brownie.png', 1),
(13, 'Helado de vainilla', 'Porción de helado cremoso', '33.30', 3, 70, NULL, 1),
(14, 'Nachos', 'Totopos con queso y salsas', '64.75', 4, 40, NULL, 1),
(15, 'Sopa de tortilla', 'Sopa tradicional mexicana', '55.50', 4, 35, NULL, 1),
(16, 'Pollo a la parrilla', 'Pechuga de pollo sazonada', '120.25', 5, 25, NULL, 1),
(17, 'Pasta boloñesa', 'Pasta con salsa de carne', '107.30', 5, 20, NULL, 1),
(18, 'Burrito de frijol', 'Burrito relleno de frijoles', '55.50', 6, 40, NULL, 1),
(19, 'Empanada de pollo', 'Empanada horneada con pollo', '46.25', 6, 60, NULL, 1),
(20, 'Pizza margarita', 'Pizza clásica de queso y tomate', '129.50', 7, 25, NULL, 1),
(21, 'Pan con ajo', 'Baguette con mantequilla de ajo', '46.25', 7, 50, NULL, 1),
(22, 'Ensalada César', 'Lechuga con aderezo César', '74.00', 8, 30, NULL, 1),
(23, 'Ensalada mixta', 'Vegetales frescos variados', '70.30', 8, 30, NULL, 1),
(24, 'Tacos de barbacoa', 'Tacos de carne barbacoa', '74.00', 9, 35, NULL, 1),
(25, 'Ceviche especial', 'Pescado marinado con limón', '120.25', 9, 20, NULL, 1),
(26, 'Aros de cebolla', 'Aros de cebolla empanizados', '40.70', 10, 40, NULL, 1),
(27, 'Arroz blanco', 'Guarnición de arroz', '27.75', 10, 50, NULL, 1),
(28, 'Cerveza artesanal', 'Botella de cerveza local', '64.75', 11, 80, NULL, 1),
(29, 'Vino tinto', 'Copa de vino de la casa', '83.25', 11, 40, NULL, 1),
(30, 'Cappuccino', 'Café con espuma de leche', '44.40', 12, 60, NULL, 1),
(31, 'Chocolate caliente', 'Bebida caliente de cacao', '37.00', 12, 50, NULL, 1),
(32, 'Chilaquiles', 'Totopos con salsa y queso', '83.25', 13, 30, NULL, 1),
(33, 'Waffles', 'Waffles con miel de maple', '59.20', 13, 20, NULL, 1),
(34, 'Mollete', 'Pan con frijoles y queso', '51.80', 6, 40, NULL, 1),
(35, 'Croissant', 'Pan francés hojaldrado', '37.00', 7, 40, NULL, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `recetas`
--

CREATE TABLE `recetas` (
  `id` int(11) NOT NULL,
  `producto_id` int(11) NOT NULL,
  `insumo_id` int(11) NOT NULL,
  `cantidad` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `recetas`
--

INSERT INTO `recetas` (`id`, `producto_id`, `insumo_id`, `cantidad`) VALUES
(1, 2, 1, '0.20'),
(2, 2, 2, '1.00'),
(3, 1, 3, '0.02'),
(4, 1, 4, '0.01'),
(5, 3, 5, '0.10'),
(6, 3, 4, '0.05');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `roles`
--

CREATE TABLE `roles` (
  `id` int(11) NOT NULL,
  `nombre` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `roles`
--

INSERT INTO `roles` (`id`, `nombre`) VALUES
(1, 'Administrador'),
(2, 'Mesero'),
(3, 'Cocina'),
(4, 'Caja');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `usuario` varchar(50) NOT NULL,
  `clave` varchar(255) NOT NULL,
  `rol_id` int(11) NOT NULL,
  `activo` tinyint(4) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id`, `nombre`, `usuario`, `clave`, `rol_id`, `activo`) VALUES
(1, 'Admin', 'admin', '0192023a7bbd73250516f069df18b500', 1, 1),
(2, 'Ana López', 'alopez', '62cc2d8b4bf2d8728120d052163a77df', 2, 1),
(3, 'Luis García', 'lgarcia', '62cc2d8b4bf2d8728120d052163a77df', 3, 1),
(4, 'Paula Ríos', 'prios', '62cc2d8b4bf2d8728120d052163a77df', 4, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ventas`
--

CREATE TABLE `ventas` (
  `id` int(11) NOT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `mesa_id` int(11) DEFAULT NULL,
  `fecha` datetime DEFAULT current_timestamp(),
  `total` decimal(10,2) NOT NULL,
  `metodo_pago_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
<<<<<<< Updated upstream
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `cajas`
--
ALTER TABLE `cajas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `usuario_id` (`usuario_id`);

--
-- Indices de la tabla `caja_movimientos`
--
ALTER TABLE `caja_movimientos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `caja_id` (`caja_id`),
  ADD KEY `venta_id` (`venta_id`),
  ADD KEY `metodo_pago_id` (`metodo_pago_id`);

=======
-- Volcado de datos para la tabla `ventas`
--

INSERT INTO `ventas` (`id`, `usuario_id`, `mesa_id`, `fecha`, `total`, `metodo_pago_id`) VALUES
(1, 2, 1, '2025-07-02 20:48:21', '11.40', 1),
(2, 3, 3, '2025-07-02 20:48:21', '2.00', 2),
(3, 1, 1, '2025-07-02 22:26:30', '4.50', 1),
(4, 1, 2, '2025-07-03 13:38:24', '227.00', 1),
(5, 1, 1, '2025-07-03 13:39:27', '157.70', 2),
(6, 1, 4, '2025-07-03 13:48:01', '1.20', 1),
(7, 1, 1, '2025-07-03 15:26:02', '6.00', 1);

--
-- Índices para tablas volcadas
--

>>>>>>> Stashed changes
--
-- Indices de la tabla `categorias`
--
ALTER TABLE `categorias`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `detalle_orden`
--
ALTER TABLE `detalle_orden`
  ADD PRIMARY KEY (`id`),
  ADD KEY `orden_id` (`orden_id`),
  ADD KEY `producto_id` (`producto_id`);

--
-- Indices de la tabla `detalle_venta`
--
ALTER TABLE `detalle_venta`
  ADD PRIMARY KEY (`id`),
  ADD KEY `venta_id` (`venta_id`),
  ADD KEY `producto_id` (`producto_id`);

--
-- Indices de la tabla `entradas_insumo`
--
ALTER TABLE `entradas_insumo`
  ADD PRIMARY KEY (`id`),
  ADD KEY `insumo_id` (`insumo_id`);

--
-- Indices de la tabla `insumos`
--
ALTER TABLE `insumos`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `mesas`
--
ALTER TABLE `mesas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `numero` (`numero`);

--
-- Indices de la tabla `metodos_pago`
--
ALTER TABLE `metodos_pago`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `ordenes`
--
ALTER TABLE `ordenes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `mesa_id` (`mesa_id`),
  ADD KEY `usuario_id` (`usuario_id`);

--
-- Indices de la tabla `productos`
--
ALTER TABLE `productos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `categoria_id` (`categoria_id`);

--
-- Indices de la tabla `recetas`
--
ALTER TABLE `recetas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `producto_id` (`producto_id`),
  ADD KEY `insumo_id` (`insumo_id`);

--
-- Indices de la tabla `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `usuario` (`usuario`),
  ADD KEY `rol_id` (`rol_id`);

--
-- Indices de la tabla `ventas`
--
ALTER TABLE `ventas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `usuario_id` (`usuario_id`),
  ADD KEY `mesa_id` (`mesa_id`),
  ADD KEY `metodo_pago_id` (`metodo_pago_id`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `categorias`
--
ALTER TABLE `categorias`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT de la tabla `detalle_orden`
--
ALTER TABLE `detalle_orden`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `detalle_venta`
--
ALTER TABLE `detalle_venta`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `entradas_insumo`
--
ALTER TABLE `entradas_insumo`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT de la tabla `insumos`
--
ALTER TABLE `insumos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT de la tabla `mesas`
--
ALTER TABLE `mesas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT de la tabla `metodos_pago`
--
ALTER TABLE `metodos_pago`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de la tabla `ordenes`
--
ALTER TABLE `ordenes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT de la tabla `productos`
--
ALTER TABLE `productos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=36;

--
-- AUTO_INCREMENT de la tabla `recetas`
--
ALTER TABLE `recetas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=42;

--
-- AUTO_INCREMENT de la tabla `roles`
--
ALTER TABLE `roles`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT de la tabla `ventas`
--
ALTER TABLE `ventas`
<<<<<<< Updated upstream
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
=======
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
>>>>>>> Stashed changes

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `detalle_orden`
--
ALTER TABLE `detalle_orden`
  ADD CONSTRAINT `detalle_orden_ibfk_1` FOREIGN KEY (`orden_id`) REFERENCES `ordenes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `detalle_orden_ibfk_2` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`);

--
-- Filtros para la tabla `detalle_venta`
--
ALTER TABLE `detalle_venta`
  ADD CONSTRAINT `detalle_venta_ibfk_1` FOREIGN KEY (`venta_id`) REFERENCES `ventas` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `detalle_venta_ibfk_2` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`);

--
-- Filtros para la tabla `entradas_insumo`
--
ALTER TABLE `entradas_insumo`
  ADD CONSTRAINT `entradas_insumo_ibfk_1` FOREIGN KEY (`insumo_id`) REFERENCES `insumos` (`id`);

--
-- Filtros para la tabla `ordenes`
--
ALTER TABLE `ordenes`
  ADD CONSTRAINT `ordenes_ibfk_1` FOREIGN KEY (`mesa_id`) REFERENCES `mesas` (`id`),
  ADD CONSTRAINT `ordenes_ibfk_2` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`);

--
-- Filtros para la tabla `productos`
--
ALTER TABLE `productos`
  ADD CONSTRAINT `productos_ibfk_1` FOREIGN KEY (`categoria_id`) REFERENCES `categorias` (`id`);

--
-- Filtros para la tabla `recetas`
--
ALTER TABLE `recetas`
  ADD CONSTRAINT `recetas_ibfk_1` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `recetas_ibfk_2` FOREIGN KEY (`insumo_id`) REFERENCES `insumos` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD CONSTRAINT `usuarios_ibfk_1` FOREIGN KEY (`rol_id`) REFERENCES `roles` (`id`);

--
-- Filtros para la tabla `ventas`
--
ALTER TABLE `ventas`
  ADD CONSTRAINT `ventas_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`),
  ADD CONSTRAINT `ventas_ibfk_2` FOREIGN KEY (`mesa_id`) REFERENCES `mesas` (`id`),
  ADD CONSTRAINT `ventas_ibfk_3` FOREIGN KEY (`metodo_pago_id`) REFERENCES `metodos_pago` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
